/*
 *  api_record.js
 *
 *  Copyright: (c) 2017 FileMaker, Inc. All rights reserved.
 *
 *  FILEMAKER CONFIDENTIAL
 *  This file includes unpublished proprietary source code of FileMaker,
 *  Inc. The copyright notice above does not evidence any actual or
 *  intended publication of such source code.
 */
'use strict';
var express = require('express');
var router = express.Router({caseSensitive: true});
var errorHandler = require('./error');
var util = require('./util');

router.route('/')
.all(function(req, res, next){
	const allowedMethods = ['GET'];
	if(util.validateRequest(req, res, allowedMethods)) {
		next();
	}
})
/**
 * @api {GET} /refreshLicense
 * @apiDescription Refresh license info.
 * @apiName refreshLicense
 * @apiGroup Misc
 *
 * @apiSuccess {String} errorCode "0"
 * @apiSuccess {String} data JSON Array which contains only on row objects
 *
 * @apiUse BadRequestError
 * @apiUse UnauthorizedError
 * @apiUse FMServiceError
 *
 *
 * @apiSampleRequest /refreshLicense
 */
.get(function(req, res, next){
	try{
		util.thrift_client.refreshLicense(
    		function(thrifError, thrifResult){
    			return util.handleThrifReturn(thrifError, thrifResult, req, res);
			});
	} catch (err) {
		util.thriftExceptionHandler(err, req, res);
	}
})


module.exports.router = router;
